const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('serialApi', {
  listPorts: () => ipcRenderer.invoke('serial:listPorts'),
  open: (cfg) => ipcRenderer.invoke('serial:open', cfg),
  close: (cfg) => ipcRenderer.invoke('serial:close', cfg),
  write: (cfg) => ipcRenderer.invoke('serial:write', cfg),
  exportLog: (cfg) => ipcRenderer.invoke('log:export', cfg),
  exportLogTxt: (cfg) => ipcRenderer.invoke('log:exportTxt', cfg),
  getHelpContent: () => ipcRenderer.invoke('help:getContent'),
  modbusScan: (cfg) => ipcRenderer.invoke('modbus:scan', cfg),
  modbusWriteRegister: (cfg) => ipcRenderer.invoke('modbus:writeRegister', cfg),
  modbusSendRawHex: (cfg) => ipcRenderer.invoke('modbus:sendRawHex', cfg),
  onEvent: (handler) => {
    const wrapped = (_event, payload) => handler(payload);
    ipcRenderer.on('serial:event', wrapped);
    return () => ipcRenderer.removeListener('serial:event', wrapped);
  }
});
