# Requirements and Installation Guide

## 1. System Requirements

- OS: Windows 10 or Windows 11
- Architecture: x64 recommended
- RAM: 4 GB minimum, 8 GB+ recommended for multi-port high-baud testing
- Disk Space:
  - 1 GB for dependencies/build cache
  - Additional space for logs/exports

## 2. Software Requirements

- Node.js: v20+ (recommended latest LTS)
- npm: included with Node.js
- PowerShell or Command Prompt
- Serial device drivers (based on your hardware):
  - Silicon Labs CP210x
  - CH340/CH341
  - FTDI VCP

## 3. Project Dependencies

From `package.json`:

Runtime dependencies:
- `serialport` ^13.0.0
- `modbus-serial` ^8.0.23

Dev/build dependencies:
- `electron` ^40.4.1
- `electron-builder` ^24.13.3
- `electron-packager` ^17.1.2

## 4. Install Requirements (Step by Step)

1. Install Node.js
- Download and install from: https://nodejs.org/
- Verify:

```powershell
node -v
npm -v
```

2. Open terminal in project folder:

```powershell Example
cd c:\Users\ELCOT\Downloads\SERIAL\serialproject
```

3. Install npm packages:

```powershell
npm install
```

If PowerShell script policy blocks npm:

```powershell
npm.cmd install
```

4. Run the application:

```powershell
npm start
```

Fallback:

```powershell
npm.cmd start
```

## 8. Quick Install Commands

```powershell
cd c:\Users\ELCOT\Downloads\SERIAL\serialproject
npm.cmd install
npm.cmd start
```
