# Serial All-In-One Lab (Node.js + Electron)

Unified desktop application for:
- Multi-COM serial monitoring and transmission
- Raw / String / Hex RX views
- TX options (line ending, repeat, delay, verify response)
- GSM testing panel (SIMCom + Quectel presets + custom AT)
- Modbus RTU read/write panel
- Timestamp-based logging and export (CSV/TXT/LOG)

## Requirements

- Windows 10/11 (x64 recommended)
- Node.js 20+ (Node 22/24/25 also works)
- npm (comes with Node.js)
- USB/COM serial drivers for your devices (CP210x, CH340, FTDI, etc. as needed)

For full details, see `REQUIREMENTS.md`.

## Features Included

- Multiple serial connections at the same time
- COM port selection with display name (path + manufacturer + VID/PID)
- Full baud preset list + custom baud input
- Standard serial options: data bits, stop bits, parity
- TX section similar to Docklight style workflows
- GSM command one-click send and repeat send controls
- Verify response and retry when expected string not matched
- Modbus section for common read function types and single register write

## Setup

```bash
cd serialproject
npm install
npm start
```

If PowerShell blocks npm script policy, use:

```bash
npm.cmd install
npm.cmd start
```

## Build EXE

```bash
npm.cmd run build:single-exe
```

Output:
- `dist/Serial Lab-Portable-1.0.0.exe`

## Notes

- GSM custom command uses CRLF by default.
- Verify response checks received text buffer for expected substring.
- Modbus panel currently opens/closes connection per request (simple and reliable baseline).

## Suggested Next Enhancements

- Save/load command profiles and test scripts
- CRC calculator widgets and Modbus frame builder view
- Auto reconnect, line-state control (RTS/DTR), and trigger automation rules
- Per-connection log filters and charting for long-run tests
