# YOLO GUI Object Detection

Tkinter-based webcam detector with model dropdown (YOLOv5/YOLOv8/YOLO11 variants).

For full details, see `DOCUMENTATION.md`.

## Features
- Select YOLO model from dropdown
- Start live webcam detection in a GUI
- Draw detection boxes in camera window
- Play beep sound when a person is detected

## Setup (Windows PowerShell)

```powershell
python -m venv .venv
.\.venv\Scripts\Activate.ps1
python -m pip install --upgrade pip
pip install -r requirements.txt
```

## Run

```powershell
.\.venv\Scripts\Activate.ps1
python app.py
```

## Usage
1. Choose a model in the dropdown.
2. Click **Start Detection**.
3. Camera window opens and detection starts.
4. Press `Q` in camera window or click **Stop Detection** to stop.

## Notes
- First run downloads model weights from the internet.
- Person class in COCO is class ID `0`.
- Beep uses `winsound` (Windows).
