/*
 * Copyright (c) 2020, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== uart2echo.c ========
 */
#include <stdint.h>
#include <stddef.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART2.h>

/* Driver configuration */
#include "ti_drivers_config.h"
#include <stdint.h>
#include <stdbool.h>
#include <ti/drivers/SPI.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/dpl/ClockP.h>
#include "ti_drivers_config.h"
/*
 *  ======== mainThread ========
 */
static SPI_Handle dacSpi;
void MCP4921_init(void);
void MCP4921_init(void)
{
    SPI_Params spiParams;
    SPI_Params_init(&spiParams);

    spiParams.frameFormat = SPI_POL0_PHA0;   // SPI Mode 0 (CPOL = 0, CPHA = 0)
    spiParams.dataSize    = 8;               // Transmit in 8-bit chunks
    spiParams.bitRate     = 1000000;         // 1 MHz (safe for MCP4921)

    dacSpi = SPI_open(CONFIG_SPI_0, &spiParams);
    if (dacSpi == NULL) {
        while (1) { /* SPI init failed */ }
    }
}
bool MCP4921_write(uint16_t value);
bool MCP4921_write(uint16_t value)
{
    SPI_Transaction trans;
    uint8_t txBuf[2];

    if (value > 0x0FFF) value = 0x0FFF;  // Clamp to 12-bit range

    // Build 16-bit command frame
    // C=0, BUF=1, GA=1 (1x Vref), SHDN=1 (Active)
    uint16_t command = (0x3 << 12) | value;  // 0x3 = 0b0011

    txBuf[0] = (uint8_t)(command >> 8);
    txBuf[1] = (uint8_t)(command & 0xFF);

    trans.count = 2;
    trans.txBuf = txBuf;
    trans.rxBuf = NULL;

    return SPI_transfer(dacSpi, &trans);
}
void *mainThread(void *arg0)
{
    SPI_init();
       GPIO_init();
       MCP4921_init();

       const int percents[] = {40, 50, 60, 75, 100};
       const int nSteps = sizeof(percents) / sizeof(percents[0]);
       const uint16_t FULL = 4095;
       const int delay_ms = 1000; // 2 seconds

       while (1) {
           for (int i = 0; i < nSteps; ++i) {
               uint32_t code = (percents[i] * FULL + 50U) / 100U;
               MCP4921_write((uint16_t)code);
               GPIO_toggle(CONFIG_GPIO_LED_0);
               ClockP_sleep(delay_ms / 1000);
               ClockP_usleep((delay_ms % 1000) * 1000);
           }
  }


}
