/*
 *  ======== ti_radio_config.c ========
 *  Configured RadioConfig module definitions
 *
 *  DO NOT EDIT - This file is generated for the CC1354P10RSK
 *  by the SysConfig tool.
 *
 *  Radio Config module version : 1.20.0
 *  SmartRF Studio data version : 2.32.0
 */

#include "ti_radio_config.h"
#include DeviceFamily_constructPath(rf_patches/rf_patch_cpe_multi_protocol.h)

// Custom overrides
#include <ti/ble5stack_flash/icall/inc/ble_overrides.h>


// *********************************************************************************
//   RF Frontend configuration
// *********************************************************************************
// RF design based on: LP_EM_CC1354P10_1

// TX Power tables
// The RF_TxPowerTable_DEFAULT_PA_ENTRY and RF_TxPowerTable_HIGH_PA_ENTRY macros are defined in RF.h.
// The following arguments are required:
// RF_TxPowerTable_DEFAULT_PA_ENTRY(bias, gain, boost, coefficient)
// RF_TxPowerTable_HIGH_PA_ENTRY(bias, ibboost, boost, coefficient, ldoTrim)
// See the Technical Reference Manual for further details about the "txPower" Command field.
// The PA settings require the CCFG_FORCE_VDDR_HH = 0 unless stated otherwise.

// 868 MHz, 13 dBm
RF_TxPowerTable_Entry txPowerTable_868_pa13[TXPOWERTABLE_868_PA13_SIZE] =
{
    {-20, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(21, 3, 0, 0, 3) }, // 0x0300D5
    {-19, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(24, 3, 0, 0, 3) }, // 0x0300D8
    {-18, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(27, 3, 0, 4, 3) }, // 0x0308DB
    {-17, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(31, 3, 0, 4, 3) }, // 0x0308DF
    {-16, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(15, 3, 0, 4, 2) }, // 0x0208CF
    {-15, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(17, 3, 0, 4, 2) }, // 0x0208D1
    {-14, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(47, 3, 0, 4, 3) }, // 0x0308EF
    {-13, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(22, 3, 0, 7, 2) }, // 0x020ED6
    {-12, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(25, 3, 0, 7, 2) }, // 0x020ED9
    {-11, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(29, 3, 0, 7, 2) }, // 0x020EDD
    {-10, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(33, 3, 0, 11, 2) }, // 0x0216E1
    {-9, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(39, 3, 0, 11, 2) }, // 0x0216E7
    {-8, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(56, 2, 0, 7, 3) }, // 0x030EB8
    {-7, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(19, 3, 0, 14, 1) }, // 0x011CD3
    {-6, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(28, 2, 0, 14, 2) }, // 0x021C9C
    {-5, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(33, 2, 0, 14, 2) }, // 0x021CA1
    {-4, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(29, 3, 0, 21, 1) }, // 0x012ADD
    {-3, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(35, 3, 0, 25, 1) }, // 0x0132E3
    {-2, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(54, 2, 0, 21, 2) }, // 0x022AB6
    {-1, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(50, 3, 0, 35, 1) }, // 0x0146F2
    {0, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(23, 2, 0, 25, 1) }, // 0x013297
    {1, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(27, 2, 0, 28, 1) }, // 0x01389B
    {2, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(37, 1, 0, 35, 2) }, // 0x024665
    {3, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(45, 1, 0, 39, 2) }, // 0x024E6D
    {4, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(49, 2, 0, 51, 1) }, // 0x0166B1
    {5, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(17, 1, 0, 28, 1) }, // 0x013851
    {6, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(22, 1, 0, 35, 1) }, // 0x014656
    {7, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(28, 1, 0, 42, 1) }, // 0x01545C
    {8, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(37, 1, 0, 56, 1) }, // 0x017065
    {9, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(35, 2, 0, 60, 0) }, // 0x0078A3
    {10, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(14, 1, 0, 32, 0) }, // 0x00404E
    {11, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(31, 1, 0, 74, 0) }, // 0x00945F
    {12, RF_TxPowerTable_CC13x4Sub1GHz_DEFAULT_PA_ENTRY(51, 0, 0, 95, 0) }, // 0x00BE33
    RF_TxPowerTable_TERMINATION_ENTRY
};

// 868 MHz, 20 dBm
RF_TxPowerTable_Entry txPowerTable_868_pa20[TXPOWERTABLE_868_PA20_SIZE] =
{
    {14, RF_TxPowerTable_HIGH_PA_ENTRY(13, 0, 0, 28, 0) }, // 0x00380D
    {15, RF_TxPowerTable_HIGH_PA_ENTRY(18, 0, 0, 36, 0) }, // 0x004812
    {16, RF_TxPowerTable_HIGH_PA_ENTRY(24, 0, 0, 43, 0) }, // 0x005618
    {17, RF_TxPowerTable_HIGH_PA_ENTRY(28, 0, 0, 51, 2) }, // 0x02661C
    {18, RF_TxPowerTable_HIGH_PA_ENTRY(34, 0, 0, 64, 4) }, // 0x048022
    {19, RF_TxPowerTable_HIGH_PA_ENTRY(15, 3, 0, 36, 4) }, // 0x0448CF
    {20, RF_TxPowerTable_HIGH_PA_ENTRY(18, 3, 0, 71, 27) }, // 0x1B8ED2
    RF_TxPowerTable_TERMINATION_ENTRY
};


// 2400 MHz, 5 dBm
RF_TxPowerTable_Entry txPowerTable_2400_pa5[TXPOWERTABLE_2400_PA5_SIZE] =
{
    {-20, RF_TxPowerTable_DEFAULT_PA_ENTRY(7, 3, 0, 0) }, // 0x00C7
    {-18, RF_TxPowerTable_DEFAULT_PA_ENTRY(9, 3, 0, 0) }, // 0x00C9
    {-15, RF_TxPowerTable_DEFAULT_PA_ENTRY(12, 3, 0, 4) }, // 0x08CC
    {-12, RF_TxPowerTable_DEFAULT_PA_ENTRY(10, 2, 0, 4) }, // 0x088A
    {-10, RF_TxPowerTable_DEFAULT_PA_ENTRY(18, 3, 0, 0) }, // 0x00D2
    {-9, RF_TxPowerTable_DEFAULT_PA_ENTRY(14, 2, 0, 7) }, // 0x0E8E
    {-6, RF_TxPowerTable_DEFAULT_PA_ENTRY(19, 2, 0, 11) }, // 0x1693
    {-5, RF_TxPowerTable_DEFAULT_PA_ENTRY(21, 2, 0, 11) }, // 0x1695
    {-3, RF_TxPowerTable_DEFAULT_PA_ENTRY(38, 3, 0, 14) }, // 0x1CE6
    {0, RF_TxPowerTable_DEFAULT_PA_ENTRY(30, 1, 0, 21) }, // 0x2A5E
    {1, RF_TxPowerTable_DEFAULT_PA_ENTRY(35, 1, 0, 25) }, // 0x3263
    {2, RF_TxPowerTable_DEFAULT_PA_ENTRY(22, 0, 0, 35) }, // 0x4616
    {3, RF_TxPowerTable_DEFAULT_PA_ENTRY(29, 0, 0, 46) }, // 0x5C1D
    {4, RF_TxPowerTable_DEFAULT_PA_ENTRY(41, 0, 0, 64) }, // 0x8029
    {5, RF_TxPowerTable_DEFAULT_PA_ENTRY(63, 0, 0, 0) }, // 0x003F
    RF_TxPowerTable_TERMINATION_ENTRY
};



//*********************************************************************************
//  RF Setting:   BLE, 2 Mbps, LE 2M
//
//  PHY:          bt5le2m
//  Setting file: setting_bt5_le_2m.json
//*********************************************************************************

// PARAMETER SUMMARY
// NB! Setting RF parameters in this design has no effect as no RF commands are selected.

// TI-RTOS RF Mode Object
RF_Mode RF_modeBle =
{
    .rfMode = RF_MODE_AUTO,
    .cpePatchFxn = &rf_patch_cpe_multi_protocol,
    .mcePatchFxn = 0,
    .rfePatchFxn = 0
};

// Overrides for CMD_BLE5_RADIO_SETUP_PA
uint32_t pOverrides_bleCommon[] =
{
    // override_ble5_setup_override_common.json
    // Rx: Set DCDC settings drive strength and deadtime trim
    (uint32_t)0x00C188C3,
    // Synth: Increase mid code calibration time to 5 us
    (uint32_t)0x00058683,
    // Synth: Increase mid code calibration time to 5 us
    HW32_ARRAY_OVERRIDE(0x4004,0x0001),
    // Synth: Increase mid code calibration time to 5 us
    (uint32_t)0x38183C30,
    // Bluetooth 5: Default to no CTE. 
    HW_REG_OVERRIDE(0x5328,0x0000),
    // Synth: Set calibration fine point code to 60 (default: 64)
    HW_REG_OVERRIDE(0x4064,0x003C),
    // Bluetooth 5: Set DTX gain -5% for 1 Mbps
    (uint32_t)0x00E787E3,
    // Bluetooth 5: Set DTX threshold 1 Mbps
    (uint32_t)0x00950803,
    // Bluetooth 5: Set DTX gain -2.5% for 2 Mbps
    (uint32_t)0x00F487F3,
    // Bluetooth 5: Set DTX threshold 2 Mbps
    (uint32_t)0x012A0823,
    // Bluetooth 5: Set synth fine code calibration interval
    HW32_ARRAY_OVERRIDE(0x4020,0x0001),
    // Bluetooth 5: Set synth fine code calibration interval
    (uint32_t)0x41005F00,
    // Bluetooth 5: Adapt to synth fine code calibration interval
    (uint32_t)0xC0040141,
    // Bluetooth 5: Adapt to synth fine code calibration interval
    (uint32_t)0x0007DD44,
    // Bluetooth 5: Set enhanced TX shape
    (uint32_t)0x000D8C73,
    // Bluetooth 5: Set pilot tone length to 35 us
    HW_REG_OVERRIDE(0x6024,0x5B20),
    // Bluetooth 5: Compensate for 35 us pilot tone length
    (uint32_t)0x01640263,
    // ti/ble5stack_flash/icall/inc/ble_overrides.h
    BLE_STACK_OVERRIDES(),
    (uint32_t)0xFFFFFFFF
};

// Overrides for CMD_BLE5_RADIO_SETUP_PA
uint32_t pOverrides_ble1Mbps[] =
{
    // override_ble5_setup_override_1mbps.json
    // Bluetooth 5: Set pilot tone length to 35 us
    HW_REG_OVERRIDE(0x5334,0x0690),
    // Bluetooth 5: Compensate for modified pilot tone length
    (uint32_t)0x018F02A3,
    // override_ble5_symbol_error_tracking.json
    // Symbol tracking: timing correction
    HW_REG_OVERRIDE(0x50D4,0x00F9),
    // Symbol tracking: reduce sample delay
    HW_REG_OVERRIDE(0x50E0,0x0087),
    // Symbol tracking: demodulation order
    HW_REG_OVERRIDE(0x50F8,0x0014),
    (uint32_t)0xFFFFFFFF
};

// Overrides for CMD_BLE5_RADIO_SETUP_PA
uint32_t pOverrides_ble2Mbps[] =
{
    // override_ble5_setup_override_2mbps.json
    // Bluetooth 5: increase low gain AGC delay for 2 Mbps
    HW_REG_OVERRIDE(0x60A4,0x7D00),
    // Rx: increase AGC hysteresis (HIGH_GAIN=15, LOW_GAIN=11)
    HW_REG_OVERRIDE(0x6098,0x75FB),
    // Bluetooth 5: Set pilot tone length to 35 us
    HW_REG_OVERRIDE(0x5334,0x0690),
    // Bluetooth 5: Compensate for modified pilot tone length
    (uint32_t)0x012D02A3,
    // override_ble5_symbol_error_tracking.json
    // Symbol tracking: timing correction
    HW_REG_OVERRIDE(0x50D4,0x00F9),
    // Symbol tracking: reduce sample delay
    HW_REG_OVERRIDE(0x50E0,0x0087),
    // Symbol tracking: demodulation order
    HW_REG_OVERRIDE(0x50F8,0x0014),
    (uint32_t)0xFFFFFFFF
};

// Overrides for CMD_BLE5_RADIO_SETUP_PA
uint32_t pOverrides_bleCoded[] =
{
    // override_ble5_setup_override_coded.json
    // Bluetooth 5: Set pilot tone length to 35 us
    HW_REG_OVERRIDE(0x5334,0x0690),
    // Bluetooth 5: Compensate for modified pilot tone length
    (uint32_t)0x07E502A3,
    // Bluetooth 5: Set AGC mangnitude target to 0x21.
    HW_REG_OVERRIDE(0x609C,0x0021),
    (uint32_t)0xFFFFFFFF
};




