<?php
error_reporting(E_ALL & ~E_NOTICE); 

if($keyhash === "123"){
include("../config/db_connect.php");
session_start();

/* Add / Update / Delete */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['delete_id'])) {
        $id = intval($_POST['delete_id']);
        mysqli_query($conn, "DELETE FROM themes WHERE id=$id");
        $_SESSION['delete'] = "Variable deleted successfully!";
    } else {
        $name = mysqli_real_escape_string($conn, $_POST['var_name']);
        $value = mysqli_real_escape_string($conn, $_POST['var_value']);
        if (!empty($_POST['id'])) {
            $id = intval($_POST['id']);
            mysqli_query($conn, "UPDATE themes SET var_value='$value' WHERE id=$id");
            $_SESSION['update'] = "Variable updated successfully!";
        } else {
            mysqli_query($conn, "INSERT INTO themes (var_name, var_value) VALUES ('$name', '$value')
            ON DUPLICATE KEY UPDATE var_value='$value'");
            $_SESSION['create'] = "Variable added successfully!";
        }
    }
    header("Location: ?page=theme");
    exit;
}

/* Fetch Variables */
$vars = mysqli_query($conn, "SELECT * FROM themes ORDER BY id ASC");

/* Generate CSS Preview */
ob_start();
echo ":root {\n";
while ($row = mysqli_fetch_assoc($vars)) {
    echo "  --{$row['var_name']}: {$row['var_value']};\n";
}
echo "}\n";
$generatedCSS = ob_get_clean();
?>

<div class="posts-list w-100 p-5">
<?php
if (isset($_SESSION["create"])) {
  echo '<div class="alert alert-success">'.$_SESSION["create"].'</div>'; unset($_SESSION["create"]);
}
if (isset($_SESSION["update"])) {
  echo '<div class="alert alert-success">'.$_SESSION["update"].'</div>'; unset($_SESSION["update"]);
}
if (isset($_SESSION["delete"])) {
  echo '<div class="alert alert-success">'.$_SESSION["delete"].'</div>'; unset($_SESSION["delete"]);
}
?>
<style>
<?= $generatedCSS ?>

.preview-box {
  background: var(--be-color-theme-primary, #0D3C7A);
  color: var(--be-color-common-white, #fff);
  padding: 40px;
  border-radius: var(--radius, 12px);
  text-align: center;
  margin-top: 20px;
  box-shadow: var(--shadow, 0 6px 20px rgba(0,0,0,0.1));
}
input.color-input {
    width: 100%;
    padding: 8px;
    border-radius: 6px;
    border: 1px solid var(--be-color-border-1, #ccc);
}
.color-box {
    width: 25px;
    height: 25px;
    border-radius: 4px;
    border: 1px solid #ccc;
    margin-left: 8px;
    display: inline-block;
}
</style>

<h3 class="mb-4 text-primary">🎨 CSS Variables Dashboard</h3>

<form method="POST" class="row g-2 mb-4">
  <div class="col-md-5">
    <input type="text" name="var_name" class="form-control" placeholder="Variable name (e.g., be-color-theme-primary)" required>
  </div>
  <div class="col-md-5">
    <input type="text" name="var_value" class="form-control" placeholder="Value (e.g., #0D3C7A)" required>
  </div>
  <div class="col-md-2">
    <button type="submit" class="btn btn-info w-100">Add / Update</button>
  </div>
</form>

<table class="table table-bordered">
  <thead>
    <tr>
      <th style="width:40%;">Variable Name</th>
      <th style="width:40%;">Value</th>
      <th style="width:20%;">Action</th>
    </tr>
  </thead>
  <tbody>
<?php
  mysqli_data_seek($vars, 0);
  while ($row = mysqli_fetch_assoc($vars)):
      $color = '';
      if(preg_match('/^#([a-fA-F0-9]{3}|[a-fA-F0-9]{6})$/', $row['var_value'])){
          $color = $row['var_value'];
      }
?>
    <tr>
      <form method="POST">
        <input type="hidden" name="id" value="<?= $row['id'] ?>">
        <td data-label="Name"><?= htmlspecialchars($row['var_name']) ?></td>
        <td data-label="Value">
          <div style="display:flex; align-items:center;">
            <input type="text" name="var_value" value="<?= htmlspecialchars($row['var_value']) ?>" class="color-input" style="flex:1;<?= $color ? "background:$color;color:".((hexdec(substr($color,1,2))+hexdec(substr($color,3,2))+hexdec(substr($color,5,2)))/3>128 ? "#000":"#fff").";" : "" ?>">
            <?php if($color): ?>
            <span class="color-box" style="background:<?= $color ?>;"></span>
            <?php endif; ?>
          </div>
        </td>
        <td data-label="Actions">
          <button class="btn btn-warning btn-sm" type="submit">Save</button>
          <button class="btn btn-danger btn-sm" name="delete_id" value="<?= $row['id'] ?>" onclick="return confirm('Delete this variable?')">Delete</button>
        </td>
      </form>
    </tr>
<?php endwhile; ?>
  </tbody>
</table>

<div class="preview-box">
  <h4 style="font-size: var(--be-fs-h2, 36px);">CSS Theme Preview</h4>
  <p style="font-size: var(--be-fs-p, 18px);">Themes root</p>
</div>

<div class="mt-4">
  <h6>Generated CSS Preview:</h6>
  <pre style="background:#eee;padding:10px;border-radius:10px;max-height:300px;overflow:auto;"><?= htmlspecialchars($generatedCSS) ?></pre>
</div>

</div>

<?php } // end if($keyhash === "123") ?>